let loginPage = require("../../PageObject/LoginPage");
let userMyAccount = require("../../PageObject/UserMyAccountPage");
let userPlanPage = require("../../PageObject/UserPlanPage");
let userMySubPage = require("../../PageObject/UserMySubPage");
let userInvoicePage = require("../../PageObject/UserInvoicePage")
let userTransactionPage = require("../../PageObject/UserTransactionPage")
const urlencoded = require('urlencode');

const webdriver = require('selenium-webdriver');
const By = webdriver.By;
const driver = require('../../../CommonStep/Web/seleniumWebDriver');
const baseStep = require('../../../CommonStep/Web/Web_Common_Step');

const API_Object = require("../../../CommonStep/API/API_Object");
const API_Env = require("../../../CommonStep/API/API_Env");
const ApiReq = new API_Object("https://api.unibee.top");

const addContext = require('mochawesome/addContext');
const {expect} = require("chai");
const {wait} = require("../../../CommonStep/Web/Web_Common_Step");
const merchantInvoicePage = require("../../PageObject/MerchantInvoicePage");
const userListPage = require("../../PageObject/MerchantUserListPage");
let request;
let response;
let timeStamp = new Date();

let Driver;
let savaPath = __dirname + "/../../Report/Web/ScreenShot/06_User_my_account/" + baseStep.getDateFormat(new Date(), "YYYY-MM-DD_HH:mm:ss");
let testData = [];
let testUser = "joshua.yu@wowow.io";
describe('case01: Update account info=> Success', function () {
    this.timeout(9000000);

    beforeEach(function () {
        response = null;
        addContext(this, {
            title: 'StartTime',
            value: {
                StartTime: timeStamp = new Date()
            }
        });
    });
    afterEach(function () {
        if (response) {
            addContext(this, {
                title: 'Request',
                value: {
                    Request: request
                }
            });
            addContext(this, {
                title: 'Response',
                value: {
                    Response: response
                }
            });
        }
        addContext(this, {
            title: 'EndTime',
            value: {
                EndTime: timeStamp = new Date()
            }
        });

    });


    it('case 01 -update account info => Success  ', (done) => {
        (async () => {
            try {
                // login
                Driver = driver.getDriver(webdriver, 'chrome');
                // Check Url
                await loginPage.openUserUrl(Driver,);
                const currentUrl = await Driver.getCurrentUrl();
                console.log('当前网址:', currentUrl);
                await baseStep.waitUntilElement(Driver, loginPage.user_email, 20000);
                await loginPage.loginUserPortal(Driver, testUser)
                await baseStep.wait(Driver, 1000);

                await baseStep.click(Driver, userMyAccount.menu_my_account);
                await baseStep.inputWithClear(Driver, userMyAccount.billing_address, "billing address" + new Date().getTime());
                await baseStep.inputWithClear(Driver, userMyAccount.company_name, "test company");
                await baseStep.scrollIntoView(Driver, userMyAccount.Save_btn);
                await baseStep.screenShot(Driver, savaPath + "/01_updateAccountInfo.png");
                await baseStep.click(Driver, userMyAccount.Save_btn);
                await baseStep.wait(Driver, 10000);
                done();
            } catch (e) {
                done(e);
            } finally {
                await Driver.quit();
            }
        })();
    });


    it('Delay 5 seconds ', (done) => {
        setTimeout(() => {// TODO Need wait about syncTimeAPI second after last operation
            done();
        }, 5000);
    });

});

describe('case02: change password=> Success', function () {
    this.timeout(9000000);

    beforeEach(function () {
        response = null;
        addContext(this, {
            title: 'StartTime',
            value: {
                StartTime: timeStamp = new Date()
            }
        });
    });
    afterEach(function () {
        if (response) {
            addContext(this, {
                title: 'Request',
                value: {
                    Request: request
                }
            });
            addContext(this, {
                title: 'Response',
                value: {
                    Response: response
                }
            });
        }
        addContext(this, {
            title: 'EndTime',
            value: {
                EndTime: timeStamp = new Date()
            }
        });

    });


    it('case 01 - change password => Success  ', (done) => {
        (async () => {
            try {
                // login
                Driver = driver.getDriver(webdriver, 'chrome');
                // Check Url
                await loginPage.openUserUrl(Driver,);
                const currentUrl = await Driver.getCurrentUrl();
                console.log('当前网址:', currentUrl);
                await baseStep.waitUntilElement(Driver, loginPage.user_email, 20000);
                await loginPage.loginUserPortal(Driver, testUser, "Aa@666666")
                await baseStep.wait(Driver, 1000);

                await baseStep.waitUntilElement(Driver, userMyAccount.menu_my_account, 20000);
                await baseStep.click(Driver, userMyAccount.menu_my_account);
                await baseStep.scrollIntoView(Driver, userMyAccount.change_password_btn);

                await baseStep.click(Driver, userMyAccount.change_password_btn);
                await baseStep.input(Driver, userMyAccount.old_password, "Aa@666666");
                await baseStep.input(Driver, userMyAccount.new_password, "Aa@777777");
                await baseStep.input(Driver, userMyAccount.new_password_confirm, "Aa@777777");
                await baseStep.screenShot(Driver, savaPath + "/02_change_password_success.png");
                await baseStep.click(Driver, userMyAccount.OK_btn);
                await baseStep.waitUntilElement(Driver, loginPage.user_email, 20000);
                await loginPage.loginUserPortal(Driver, testUser, "Aa@777777");

                await baseStep.wait(Driver, 1000);

                await baseStep.click(Driver, userMyAccount.menu_my_account);
                await baseStep.scrollIntoView(Driver, userMyAccount.change_password_btn);

                await baseStep.click(Driver, userMyAccount.change_password_btn);
                await baseStep.input(Driver, userMyAccount.old_password, "Aa@777777");
                await baseStep.input(Driver, userMyAccount.new_password, "Aa@666666");
                await baseStep.input(Driver, userMyAccount.new_password_confirm, "Aa@666666");
                await baseStep.click(Driver, userMyAccount.OK_btn);



                await baseStep.wait(Driver, 10000);
                done();
            } catch (e) {
                done(e);
            } finally {
                await Driver.quit();
            }
        })();
    });


    it('Delay 5 seconds ', (done) => {
        setTimeout(() => {// TODO Need wait about syncTimeAPI second after last operation
            done();
        }, 5000);
    });

});

describe('case03: change stripe to wire_transfer=> Failed', function () {
    this.timeout(9000000);

    beforeEach(function () {
        response = null;
        addContext(this, {
            title: 'StartTime',
            value: {
                StartTime: timeStamp = new Date()
            }
        });
    });
    afterEach(function () {
        if (response) {
            addContext(this, {
                title: 'Request',
                value: {
                    Request: request
                }
            });
            addContext(this, {
                title: 'Response',
                value: {
                    Response: response
                }
            });
        }
        addContext(this, {
            title: 'EndTime',
            value: {
                EndTime: timeStamp = new Date()
            }
        });

    });


    it('case 01 - change stripe to wire_transfer => Success  ', (done) => {
        (async () => {
            try {
                // login
                Driver = driver.getDriver(webdriver, 'chrome');
                // Check Url
                await loginPage.openUserUrl(Driver,);
                const currentUrl = await Driver.getCurrentUrl();
                console.log('当前网址:', currentUrl);
                await baseStep.waitUntilElement(Driver, loginPage.user_email, 20000);
                await loginPage.loginUserPortal(Driver, testUser, "Aa@666666")
                await baseStep.wait(Driver, 1000);
                await baseStep.waitUntilElement(Driver, userMyAccount.menu_my_account, 20000);
                await baseStep.click(Driver, userMyAccount.menu_my_account);

                await baseStep.scrollIntoView(Driver, userMyAccount.payment_wire_transfer)
                await baseStep.click(Driver, userMyAccount.payment_wire_transfer);

                await baseStep.scrollIntoView(Driver, userMyAccount.Save_btn)
                await baseStep.click(Driver, userMyAccount.Save_btn);
                await baseStep.screenShot(Driver, savaPath + "/03_error_message.png");
                await baseStep.wait(Driver, 1000);
                expect(userMyAccount.change_wire_error_message).to.be.exist;

                await baseStep.wait(Driver, 2000);

                done();
            } catch (e) {
                done(e);
            } finally {
                await Driver.quit();
            }
        })();
    });


    it('Delay 5 seconds ', (done) => {
        setTimeout(() => {// TODO Need wait about syncTimeAPI second after last operation
            done();
        }, 5000);
    });

});

describe('case04: change stripe to crypto=> Success', function () {
    this.timeout(9000000);

    beforeEach(function () {
        response = null;
        addContext(this, {
            title: 'StartTime',
            value: {
                StartTime: timeStamp = new Date()
            }
        });
    });
    afterEach(function () {
        if (response) {
            addContext(this, {
                title: 'Request',
                value: {
                    Request: request
                }
            });
            addContext(this, {
                title: 'Response',
                value: {
                    Response: response
                }
            });
        }
        addContext(this, {
            title: 'EndTime',
            value: {
                EndTime: timeStamp = new Date()
            }
        });

    });


    it('case 01 - change stripe to crypto => Success  ', (done) => {
        (async () => {
            try {
                // login
                Driver = driver.getDriver(webdriver, 'chrome');
                // Check Url
                await loginPage.openUserUrl(Driver,);
                const currentUrl = await Driver.getCurrentUrl();
                console.log('当前网址:', currentUrl);
                await baseStep.waitUntilElement(Driver, loginPage.user_email, 20000);
                await loginPage.loginUserPortal(Driver, testUser, "Aa@666666")
                await baseStep.wait(Driver, 1000);
                await baseStep.waitUntilElement(Driver, userMyAccount.menu_my_account, 20000);
                await baseStep.click(Driver, userMyAccount.menu_my_account);

                await baseStep.scrollIntoView(Driver, userMyAccount.payment_crypto)
                await baseStep.click(Driver, userMyAccount.payment_crypto);
                await baseStep.screenShot(Driver, savaPath + "/04_change_to_crypto.png");
                await baseStep.scrollIntoView(Driver, userMyAccount.Save_btn)
                await baseStep.click(Driver, userMyAccount.Save_btn);
                await baseStep.wait(Driver, 1000);
                await baseStep.click(Driver, userMyAccount.payment_stripe);
                await baseStep.click(Driver, userMyAccount.Save_btn);
                done();
            } catch (e) {
                done(e);
            } finally {
                await Driver.quit();
            }
        })();
    });


    it('Delay 5 seconds ', (done) => {
        setTimeout(() => {// TODO Need wait about syncTimeAPI second after last operation
            done();
        }, 5000);
    });

});

describe('case05: switch card as auto payment => Success', function () {
    this.timeout(9000000);

    beforeEach(function () {
        response = null;
        addContext(this, {
            title: 'StartTime',
            value: {
                StartTime: timeStamp = new Date()
            }
        });
    });
    afterEach(function () {
        if (response) {
            addContext(this, {
                title: 'Request',
                value: {
                    Request: request
                }
            });
            addContext(this, {
                title: 'Response',
                value: {
                    Response: response
                }
            });
        }
        addContext(this, {
            title: 'EndTime',
            value: {
                EndTime: timeStamp = new Date()
            }
        });

    });


    it('case 01 - switch card as auto payment => Success  ', (done) => {
        (async () => {
            try {
                // login
                Driver = driver.getDriver(webdriver, 'chrome');
                // Check Url
                await loginPage.openUserUrl(Driver,);
                const currentUrl = await Driver.getCurrentUrl();
                console.log('当前网址:', currentUrl);
                await baseStep.waitUntilElement(Driver, loginPage.user_email, 20000);
                await loginPage.loginUserPortal(Driver, testUser, "Aa@666666")
                await baseStep.wait(Driver, 1000);
                await baseStep.waitUntilElement(Driver, userMyAccount.menu_my_account, 20000);
                await baseStep.click(Driver, userMyAccount.menu_my_account);
                await baseStep.scrollIntoView(Driver, userMyAccount.set_as_auto_payment);

                await baseStep.refreshPage(Driver);
                await baseStep.waitUntilElement(Driver, userMyAccount.auto_pay_radio_2, 20000);
                await baseStep.click(Driver, userMyAccount.auto_pay_radio_2);
                await baseStep.click(Driver, userMyAccount.set_as_auto_payment);

                await baseStep.screenShot(Driver, savaPath + "/05_switch_card.png");
                await baseStep.scrollIntoView(Driver, userMyAccount.Save_btn)
                await baseStep.click(Driver, userMyAccount.Save_btn);
                await baseStep.wait(Driver, 1000);
                done();
            } catch (e) {
                done(e);
            } finally {
                await Driver.quit();
            }
        })();
    });


    it('Delay 5 seconds ', (done) => {
        setTimeout(() => {// TODO Need wait about syncTimeAPI second after last operation
            done();
        }, 5000);
    });

});

describe('case06: Add card as auto payment => Success', function () {
    this.timeout(9000000);

    beforeEach(function () {
        response = null;
        addContext(this, {
            title: 'StartTime',
            value: {
                StartTime: timeStamp = new Date()
            }
        });
    });
    afterEach(function () {
        if (response) {
            addContext(this, {
                title: 'Request',
                value: {
                    Request: request
                }
            });
            addContext(this, {
                title: 'Response',
                value: {
                    Response: response
                }
            });
        }
        addContext(this, {
            title: 'EndTime',
            value: {
                EndTime: timeStamp = new Date()
            }
        });

    });


    it('case 01 - Add card as auto payment  ', (done) => {
        (async () => {
            try {
                // login
                Driver = driver.getDriver(webdriver, 'chrome');
                // Check Url
                await loginPage.openUserUrl(Driver,);
                const currentUrl = await Driver.getCurrentUrl();
                console.log('当前网址:', currentUrl);
                await baseStep.waitUntilElement(Driver, loginPage.user_email, 20000);
                await loginPage.loginUserPortal(Driver, testUser );
                await baseStep.wait(Driver, 1000);
                await baseStep.waitUntilElement(Driver, userMyAccount.menu_my_account, 20000);
                await baseStep.click(Driver, userMyAccount.menu_my_account);
                await baseStep.refreshPage(Driver);
                await baseStep.wait(Driver, 5000);
                await baseStep.waitUntilElement(Driver, userMyAccount.add_new_card, 20000);
                await baseStep.click(Driver, userMyAccount.add_new_card);

                await baseStep.wait(Driver, 1000);
                await baseStep.switchWindow(Driver);
                await baseStep.waitUntilElement(Driver, userPlanPage.card_number, 20000);
                await baseStep.input(Driver, userPlanPage.card_number, '5555555555554444');
                await baseStep.input(Driver, userPlanPage.card_expiry, '1234');
                await baseStep.wait(Driver, 1000);
                await baseStep.input(Driver, userPlanPage.card_cvc, '567');
                await baseStep.input(Driver, userPlanPage.billing_name, "Joshua");
                await baseStep.wait(Driver, 1000);
                await baseStep.click(Driver, userPlanPage.pay_btn);
                await baseStep.waitUntilElement(Driver, userPlanPage.add_card_success_sign, 20000);
                let actual_success_text = await baseStep.getText(Driver, userPlanPage.add_card_success_sign);
                await expect("Adding new payment method succeeded").to.equal(actual_success_text);

                await baseStep.screenShot(Driver, savaPath + "/06_add_card.png");
                await baseStep.wait(Driver, 1000);
                done();
            } catch (e) {
                done(e);
            } finally {
                await Driver.quit();
            }
        })();
    });


    it('Delay 5 seconds ', (done) => {
        setTimeout(() => {// TODO Need wait about syncTimeAPI second after last operation
            done();
        }, 5000);
    });

});

describe('case07: Delete card  => Success', function () {
    this.timeout(9000000);

    beforeEach(function () {
        response = null;
        addContext(this, {
            title: 'StartTime',
            value: {
                StartTime: timeStamp = new Date()
            }
        });
    });
    afterEach(function () {
        if (response) {
            addContext(this, {
                title: 'Request',
                value: {
                    Request: request
                }
            });
            addContext(this, {
                title: 'Response',
                value: {
                    Response: response
                }
            });
        }
        addContext(this, {
            title: 'EndTime',
            value: {
                EndTime: timeStamp = new Date()
            }
        });

    });


    it('case 01 - delete card ', (done) => {
        (async () => {
            try {
                // login
                Driver = driver.getDriver(webdriver, 'chrome');
                // Check Url
                await loginPage.openUserUrl(Driver,);
                const currentUrl = await Driver.getCurrentUrl();
                console.log('当前网址:', currentUrl);
                await baseStep.waitUntilElement(Driver, loginPage.user_email, 20000);
                await loginPage.loginUserPortal(Driver, testUser );
                await baseStep.wait(Driver, 1000);
                await baseStep.waitUntilElement(Driver, userMyAccount.menu_my_account, 20000);
                await baseStep.click(Driver, userMyAccount.menu_my_account);
                await baseStep.refreshPage(Driver);
                await baseStep.wait(Driver, 5000);
                await baseStep.waitUntilElement(Driver, userMyAccount.auto_pay_delete_2, 20000);
                await baseStep.click(Driver, userMyAccount.auto_pay_delete_2);

                await baseStep.screenShot(Driver, savaPath + "/07_delete_card.png");
                await baseStep.click(Driver, userMyAccount.delete_yes_btn);
                await baseStep.wait(Driver, 1000);
                done();
            } catch (e) {
                done(e);
            } finally {
                await Driver.quit();
            }
        })();
    });


    it('Delay 5 seconds ', (done) => {
        setTimeout(() => {// TODO Need wait about syncTimeAPI second after last operation
            done();
        }, 5000);
    });

});

describe('case08: Update account info: wrong vat number=> Success', function () {
    this.timeout(9000000);

    beforeEach(function () {
        response = null;
        addContext(this, {
            title: 'StartTime',
            value: {
                StartTime: timeStamp = new Date()
            }
        });
    });
    afterEach(function () {
        if (response) {
            addContext(this, {
                title: 'Request',
                value: {
                    Request: request
                }
            });
            addContext(this, {
                title: 'Response',
                value: {
                    Response: response
                }
            });
        }
        addContext(this, {
            title: 'EndTime',
            value: {
                EndTime: timeStamp = new Date()
            }
        });

    });


    it('case 01 - add wrong vat number  => Success  ', (done) => {
        (async () => {
            try {
                // login
                Driver = driver.getDriver(webdriver, 'chrome');
                // Check Url
                await loginPage.openUserUrl(Driver,);
                const currentUrl = await Driver.getCurrentUrl();
                console.log('当前网址:', currentUrl);
                await baseStep.waitUntilElement(Driver, loginPage.user_email, 20000);
                await loginPage.loginUserPortal(Driver, testUser)
                await baseStep.wait(Driver, 1000);

                await baseStep.click(Driver, userMyAccount.menu_my_account);
                await baseStep.inputWithClear(Driver, userMyAccount.VATNumber, "123456789" );
                await baseStep.scrollIntoView(Driver, userMyAccount.Save_btn);
                await baseStep.click(Driver, userMyAccount.Save_btn);
                await baseStep.screenShot(Driver, savaPath + "/08_vat_error_message.png");
                expect(await baseStep.getText(Driver, userMyAccount.vat_error_message)).not.null
                await baseStep.wait(Driver, 3000);
                done();
            } catch (e) {
                done(e);
            } finally {
                await Driver.quit();
            }
        })();
    });


    it('Delay 5 seconds ', (done) => {
        setTimeout(() => {// TODO Need wait about syncTimeAPI second after last operation
            done();
        }, 5000);
    });

});

describe('case09: Update account info:  vat number and country=> Success', function () {
    this.timeout(9000000);

    beforeEach(function () {
        response = null;
        addContext(this, {
            title: 'StartTime',
            value: {
                StartTime: timeStamp = new Date()
            }
        });
    });
    afterEach(function () {
        if (response) {
            addContext(this, {
                title: 'Request',
                value: {
                    Request: request
                }
            });
            addContext(this, {
                title: 'Response',
                value: {
                    Response: response
                }
            });
        }
        addContext(this, {
            title: 'EndTime',
            value: {
                EndTime: timeStamp = new Date()
            }
        });

    });


    it('case 01 - add vat number and country => Success  ', (done) => {
        (async () => {
            try {
                // login
                Driver = driver.getDriver(webdriver, 'chrome');
                // Check Url
                await loginPage.openUserUrl(Driver,);
                const currentUrl = await Driver.getCurrentUrl();
                console.log('当前网址:', currentUrl);
                await baseStep.waitUntilElement(Driver, loginPage.user_email, 20000);
                await loginPage.loginUserPortal(Driver, testUser)
                await baseStep.wait(Driver, 1000);

                await baseStep.click(Driver, userMyAccount.menu_my_account);

                await baseStep.scrollIntoView(Driver, userMyAccount.VATNumber);
                await userMyAccount.setCountry(Driver,"United Kingdom");
                await baseStep.inputWithClear(Driver, userMyAccount.VATNumber, "GB288305674");
                await baseStep.screenShot(Driver, savaPath + "/09_vat_number_country.png");
                await baseStep.scrollIntoView(Driver, userMyAccount.Save_btn);
                await baseStep.click(Driver, userMyAccount.Save_btn);
                await baseStep.wait(Driver, 3000);
                done();
            } catch (e) {
                done(e);
            } finally {
                await Driver.quit();
            }
        })();
    });


    it('Delay 5 seconds ', (done) => {
        setTimeout(() => {// TODO Need wait about syncTimeAPI second after last operation
            done();
        }, 5000);
    });

});

describe('case10: Update account info:  wrong country=> Success', function () {
    this.timeout(9000000);

    beforeEach(function () {
        response = null;
        addContext(this, {
            title: 'StartTime',
            value: {
                StartTime: timeStamp = new Date()
            }
        });
    });
    afterEach(function () {
        if (response) {
            addContext(this, {
                title: 'Request',
                value: {
                    Request: request
                }
            });
            addContext(this, {
                title: 'Response',
                value: {
                    Response: response
                }
            });
        }
        addContext(this, {
            title: 'EndTime',
            value: {
                EndTime: timeStamp = new Date()
            }
        });

    });


    it('case 01 - add vat number and country => Success  ', (done) => {
        (async () => {
            try {
                // login
                Driver = driver.getDriver(webdriver, 'chrome');
                // Check Url
                await loginPage.openUserUrl(Driver,);
                const currentUrl = await Driver.getCurrentUrl();
                console.log('当前网址:', currentUrl);
                await baseStep.waitUntilElement(Driver, loginPage.user_email, 20000);
                await loginPage.loginUserPortal(Driver, testUser)
                await baseStep.wait(Driver, 1000);

                await baseStep.click(Driver, userMyAccount.menu_my_account);

                await baseStep.scrollIntoView(Driver, userMyAccount.VATNumber);
                await userMyAccount.setCountry(Driver,"China");
                await baseStep.screenShot(Driver, savaPath + "/10_wrong_country.png");
                await baseStep.scrollIntoView(Driver, userMyAccount.Save_btn);
                await baseStep.click(Driver, userMyAccount.Save_btn);
                expect(await baseStep.getText(Driver, userMyAccount.country_error_message)).not.null;

                await baseStep.scrollIntoView(Driver, userMyAccount.VATNumber);
                await userMyAccount.setCountry(Driver,"United Kingdom");
                await baseStep.inputWithClear(Driver, userListPage.account_vat_number, "");
                await baseStep.scrollIntoView(Driver, userMyAccount.Save_btn);
                await baseStep.click(Driver, userMyAccount.Save_btn);
                await baseStep.wait(Driver, 3000);
                done();
            } catch (e) {
                done(e);
            } finally {
                await Driver.quit();
            }
        })();
    });


    it('Delay 5 seconds ', (done) => {
        setTimeout(() => {// TODO Need wait about syncTimeAPI second after last operation
            done();
        }, 5000);
    });

});








