let loginPage = require("../../PageObject/LoginPage");
let userPlanPage = require("../../PageObject/UserPlanPage");
let userMySubPage = require("../../PageObject/UserMySubPage");
let userInvoicePage = require("../../PageObject/UserInvoicePage")
let merchantTransactionPage = require("../../PageObject/MerchantTransactionPage")
let merchantMyAccount = require("../../PageObject/MerchantMyAccountPage")
const urlencoded = require('urlencode');

const webdriver = require('selenium-webdriver');
const By = webdriver.By;
const driver = require('../../../CommonStep/Web/seleniumWebDriver');
const baseStep = require('../../../CommonStep/Web/Web_Common_Step');

const API_Object = require("../../../CommonStep/API/API_Object");
const API_Env = require("../../../CommonStep/API/API_Env");
const ApiReq = new API_Object("https://api.unibee.top");

const addContext = require('mochawesome/addContext');
const {expect} = require("chai");
const {wait} = require("../../../CommonStep/Web/Web_Common_Step");
const merchantInvoicePage = require("../../PageObject/MerchantInvoicePage");
let request;
let response;
let timeStamp = new Date();

let Driver;
let savaPath = __dirname + "/../../Report/Web/ScreenShot/07_Account_info/" + baseStep.getDateFormat(new Date(), "YYYY-MM-DD_HH:mm:ss");
let testData = [];
let testUser = "joshua.yu@wowow.io";
describe('case01: update account info=> Success', function () {
    this.timeout(9000000);

    beforeEach(function () {
        response = null;
        addContext(this, {
            title: 'StartTime',
            value: {
                StartTime: timeStamp = new Date()
            }
        });
    });
    afterEach(function () {
        if (response) {
            addContext(this, {
                title: 'Request',
                value: {
                    Request: request
                }
            });
            addContext(this, {
                title: 'Response',
                value: {
                    Response: response
                }
            });
        }
        addContext(this, {
            title: 'EndTime',
            value: {
                EndTime: timeStamp = new Date()
            }
        });

    });

    it('case 01 - update my account info => Success  ', (done) => {
        (async () => {
            try {
                // login
                Driver = driver.getDriver(webdriver, 'chrome');
                // Check Url
                await loginPage.openMerchantUrl(Driver);
                const currentUrl = await Driver.getCurrentUrl();
                await loginPage.loginMerchant(Driver);
                await baseStep.waitUntilElement(Driver, merchantMyAccount.menu_My_Account);
                await baseStep.click(Driver, merchantMyAccount.menu_My_Account);
                await baseStep.wait(Driver, 1000);
                await baseStep.inputWithClear(Driver, merchantMyAccount.company_name, "Automation Update Name");
                await baseStep.inputWithClear(Driver, merchantMyAccount.physical_address, "Automation Update Address");
                await baseStep.inputWithClear(Driver, merchantMyAccount.company_email, "test@test.com");
                await baseStep.inputWithClear(Driver, merchantMyAccount.company_phone, "12345678910");
                await baseStep.click(Driver, merchantMyAccount.save_btn);
                await baseStep.wait(Driver, 10000);
                await baseStep.screenShot(Driver, savaPath + '/01_update_info');
                await baseStep.compareValueText(Driver, merchantMyAccount.company_name, "Automation Update Name");
                await baseStep.compareValueText(Driver, merchantMyAccount.physical_address, "Automation Update Address");
                await baseStep.compareValueText(Driver, merchantMyAccount.company_email, "test@test.com");
                await baseStep.compareValueText(Driver, merchantMyAccount.company_phone, "12345678910");
                await baseStep.wait(Driver, 3000);
                await baseStep.inputWithClear(Driver, merchantMyAccount.company_name, "Automation Company");
                await baseStep.inputWithClear(Driver, merchantMyAccount.physical_address, "Test Address");
                await baseStep.inputWithClear(Driver, merchantMyAccount.company_email, "joshua.yu+8@wowow.io");
                await baseStep.inputWithClear(Driver, merchantMyAccount.company_phone, "15642543250");
                await baseStep.click(Driver, merchantMyAccount.save_btn);
                await baseStep.wait(Driver, 10000);
                await baseStep.screenShot(Driver, savaPath + '/02_revert_info');
                await baseStep.wait(Driver, 3000);
                done();
            } catch (e) {
                done(e);
            } finally {
                await Driver.quit();
            }
        })();
    });


    it('Delay 5 seconds ', (done) => {
        setTimeout(() => {// TODO Need wait about syncTimeAPI second after last operation
            done();
        }, 5000);
    });

});










