let loginPage = require("../../PageObject/LoginPage");
let billableMetricPage = require("../../PageObject/MerchantBillableMetricPage");

const webdriver = require('selenium-webdriver');
const By = webdriver.By;
const driver = require('../../../CommonStep/Web/seleniumWebDriver');
const baseStep = require('../../../CommonStep/Web/Web_Common_Step');

const addContext = require('mochawesome/addContext');
const {expect} = require("chai");
let request;
let response;
let timeStamp = new Date();

let Driver;
let savaPath = __dirname + "/../../Report/Web/ScreenShot/03_billable_metric/" + baseStep.getDateFormat(new Date(), "YYYY-MM-DD_HH:mm:ss");


describe('case01: Add billable metric in Merchant Portal, Aggregation Type = count=> Success', function () {
    this.timeout(100000);

    beforeEach(function () {
        response = null;
        addContext(this, {
            title: 'StartTime',
            value: {
                StartTime: timeStamp = new Date()
            }
        });
    });
    afterEach(function () {
        if (response) {
            addContext(this, {
                title: 'Request',
                value: {
                    Request: request
                }
            });
            addContext(this, {
                title: 'Response',
                value: {
                    Response: response
                }
            });
        }
        addContext(this, {
            title: 'EndTime',
            value: {
                EndTime: timeStamp = new Date()
            }
        });

    });

    it('TC001 - add billable metric ,Aggregation Type = count => Success  ', (done) => {
        (async () => {
            try {
                // login 
                Driver = driver.getDriver(webdriver, 'chrome');
                // Check Url
                await loginPage.openMerchantUrl(Driver);
                const currentUrl = await Driver.getCurrentUrl();
                console.log('当前网址:', currentUrl);
                await baseStep.waitUntilElement(Driver, loginPage.email, 20000);
                await loginPage.loginMerchant(Driver)
                await baseStep.wait(Driver, 1000);
                await baseStep.screenShot(Driver, savaPath + '/01_Menu.jpeg');
                await baseStep.wait(Driver, 1000);
                await baseStep.click(Driver, billableMetricPage.menu_billable_metric);
                await baseStep.wait(Driver, 1000);
                await baseStep.click(Driver, billableMetricPage.new_billable_metric);
                await baseStep.wait(Driver, 1000);
                await baseStep.input(Driver, billableMetricPage.metric_name, "name" + new Date().getTime());
                await baseStep.input(Driver, billableMetricPage.metric_code, "code" + new Date().getTime());
                await baseStep.input(Driver, billableMetricPage.metric_description, "description" + new Date().getTime());
                await billableMetricPage.selectAggregationType(Driver, "count");
                await baseStep.screenShot(Driver, savaPath + '/02_info_count.jpeg');
                await baseStep.click(Driver, billableMetricPage.save_btn);
                await baseStep.wait(Driver, 3000);
                await baseStep.screenShot(Driver, savaPath + '/03_list.jpeg');

                done();
            } catch (e) {
                done(e);
            } finally {
                await Driver.quit();
            }
        })();
    });

    it('Delay 5 seconds ', (done) => {
        setTimeout(() => {// TODO Need wait about syncTimeAPI second after last operation
            done();
        }, 5000);
    });

});

describe('case02: Add billable metric in Merchant Portal, Aggregation Type = count unique=> Success', function () {
    this.timeout(100000);

    beforeEach(function () {
        response = null;
        addContext(this, {
            title: 'StartTime',
            value: {
                StartTime: timeStamp = new Date()
            }
        });
    });
    afterEach(function () {
        if (response) {
            addContext(this, {
                title: 'Request',
                value: {
                    Request: request
                }
            });
            addContext(this, {
                title: 'Response',
                value: {
                    Response: response
                }
            });
        }
        addContext(this, {
            title: 'EndTime',
            value: {
                EndTime: timeStamp = new Date()
            }
        });

    });

    it('TC001 - add billable metric ,Aggregation Type = count unique => Success  ', (done) => {
        (async () => {
            try {
                // login
                Driver = driver.getDriver(webdriver, 'chrome');
                // Check Url
                await loginPage.openMerchantUrl(Driver);
                const currentUrl = await Driver.getCurrentUrl();
                console.log('当前网址:', currentUrl);
                await baseStep.waitUntilElement(Driver, loginPage.email, 20000);
                await loginPage.loginMerchant(Driver)
                await baseStep.wait(Driver, 1000);
                await baseStep.click(Driver, billableMetricPage.menu_billable_metric);
                await baseStep.wait(Driver, 1000);
                await baseStep.click(Driver, billableMetricPage.new_billable_metric);
                await baseStep.wait(Driver, 1000);
                await baseStep.input(Driver, billableMetricPage.metric_name, "name" + new Date().getTime());
                await baseStep.input(Driver, billableMetricPage.metric_code, "code" + new Date().getTime());
                await baseStep.input(Driver, billableMetricPage.metric_description, "description" + new Date().getTime());
                await billableMetricPage.selectAggregationType(Driver, "count unique");
                await baseStep.input(Driver, billableMetricPage.aggregation_property, "100");
                await baseStep.screenShot(Driver, savaPath + '/04_info_count_unique.jpeg');
                await baseStep.click(Driver, billableMetricPage.save_btn);
                await baseStep.wait(Driver, 3000);
                await baseStep.screenShot(Driver, savaPath + '/05_list.jpeg');

                done();
            } catch (e) {
                done(e);
            } finally {
                await Driver.quit();
            }
        })();
    });

    it('Delay 5 seconds ', (done) => {
        setTimeout(() => {// TODO Need wait about syncTimeAPI second after last operation
            done();
        }, 5000);
    });

});

describe('case03: Add billable metric in Merchant Portal, Aggregation Type = latest=> Success', function () {
    this.timeout(100000);

    beforeEach(function () {
        response = null;
        addContext(this, {
            title: 'StartTime',
            value: {
                StartTime: timeStamp = new Date()
            }
        });
    });
    afterEach(function () {
        if (response) {
            addContext(this, {
                title: 'Request',
                value: {
                    Request: request
                }
            });
            addContext(this, {
                title: 'Response',
                value: {
                    Response: response
                }
            });
        }
        addContext(this, {
            title: 'EndTime',
            value: {
                EndTime: timeStamp = new Date()
            }
        });

    });

    it('TC001 - add billable metric ,Aggregation Type = latest => Success  ', (done) => {
        (async () => {
            try {
                // login
                Driver = driver.getDriver(webdriver, 'chrome');
                // Check Url
                await loginPage.openMerchantUrl(Driver);
                const currentUrl = await Driver.getCurrentUrl();
                console.log('当前网址:', currentUrl);
                await baseStep.waitUntilElement(Driver, loginPage.email, 20000);
                await loginPage.loginMerchant(Driver)
                await baseStep.wait(Driver, 1000);
                await baseStep.screenShot(Driver, savaPath + '/02_Menu.jpeg');
                await baseStep.wait(Driver, 1000);
                await baseStep.click(Driver, billableMetricPage.menu_billable_metric);
                await baseStep.wait(Driver, 1000);
                await baseStep.click(Driver, billableMetricPage.new_billable_metric);
                await baseStep.wait(Driver, 1000);
                await baseStep.input(Driver, billableMetricPage.metric_name, "name" + new Date().getTime());
                await baseStep.input(Driver, billableMetricPage.metric_code, "code" + new Date().getTime());
                await baseStep.input(Driver, billableMetricPage.metric_description, "description" + new Date().getTime());
                await billableMetricPage.selectAggregationType(Driver, "latest");
                await baseStep.input(Driver, billableMetricPage.aggregation_property, "100");
                await baseStep.screenShot(Driver, savaPath + '/06_info_latest.jpeg');
                await baseStep.click(Driver, billableMetricPage.save_btn);

                await baseStep.wait(Driver, 3000);
                await baseStep.screenShot(Driver, savaPath + '/07_list.jpeg');

                done();
            } catch (e) {
                done(e);
            } finally {
                await Driver.quit();
            }
        })();
    });

    it('Delay 5 seconds ', (done) => {
        setTimeout(() => {// TODO Need wait about syncTimeAPI second after last operation
            done();
        }, 5000);
    });

});

describe('case04: Add billable metric in Merchant Portal, Aggregation Type = max=> Success', function () {
    this.timeout(100000);

    beforeEach(function () {
        response = null;
        addContext(this, {
            title: 'StartTime',
            value: {
                StartTime: timeStamp = new Date()
            }
        });
    });
    afterEach(function () {
        if (response) {
            addContext(this, {
                title: 'Request',
                value: {
                    Request: request
                }
            });
            addContext(this, {
                title: 'Response',
                value: {
                    Response: response
                }
            });
        }
        addContext(this, {
            title: 'EndTime',
            value: {
                EndTime: timeStamp = new Date()
            }
        });

    });

    it('TC001 - add billable metric ,Aggregation Type = max => Success  ', (done) => {
        (async () => {
            try {
                // login
                Driver = driver.getDriver(webdriver, 'chrome');
                // Check Url
                await loginPage.openMerchantUrl(Driver);
                const currentUrl = await Driver.getCurrentUrl();
                console.log('当前网址:', currentUrl);
                await baseStep.waitUntilElement(Driver, loginPage.email, 20000);
                await loginPage.loginMerchant(Driver)
                await baseStep.wait(Driver, 1000);
                await baseStep.screenShot(Driver, savaPath + '/02_Menu.jpeg');
                await baseStep.wait(Driver, 1000);
                await baseStep.click(Driver, billableMetricPage.menu_billable_metric);
                await baseStep.wait(Driver, 1000);
                await baseStep.click(Driver, billableMetricPage.new_billable_metric);
                await baseStep.wait(Driver, 1000);
                await baseStep.input(Driver, billableMetricPage.metric_name, "name" + new Date().getTime());
                await baseStep.input(Driver, billableMetricPage.metric_code, "code" + new Date().getTime());
                await baseStep.input(Driver, billableMetricPage.metric_description, "description" + new Date().getTime());
                await billableMetricPage.selectAggregationType(Driver, "max");
                await baseStep.input(Driver, billableMetricPage.aggregation_property, "100");
                await baseStep.screenShot(Driver, savaPath + '/08_info_max.jpeg');
                await baseStep.click(Driver, billableMetricPage.save_btn);

                await baseStep.wait(Driver, 3000);
                await baseStep.screenShot(Driver, savaPath + '/09_list.jpeg');

                done();
            } catch (e) {
                done(e);
            } finally {
                await Driver.quit();
            }
        })();
    });

    it('Delay 5 seconds ', (done) => {
        setTimeout(() => {// TODO Need wait about syncTimeAPI second after last operation
            done();
        }, 5000);
    });

});

describe('case05: Add billable metric in Merchant Portal, Aggregation Type = sum=> Success', function () {
    this.timeout(100000);

    beforeEach(function () {
        response = null;
        addContext(this, {
            title: 'StartTime',
            value: {
                StartTime: timeStamp = new Date()
            }
        });
    });
    afterEach(function () {
        if (response) {
            addContext(this, {
                title: 'Request',
                value: {
                    Request: request
                }
            });
            addContext(this, {
                title: 'Response',
                value: {
                    Response: response
                }
            });
        }
        addContext(this, {
            title: 'EndTime',
            value: {
                EndTime: timeStamp = new Date()
            }
        });

    });

    it('TC001 - add billable metric ,Aggregation Type = sum => Success  ', (done) => {
        (async () => {
            try {
                // login
                Driver = driver.getDriver(webdriver, 'chrome');
                // Check Url
                await loginPage.openMerchantUrl(Driver);
                const currentUrl = await Driver.getCurrentUrl();
                console.log('当前网址:', currentUrl);
                await baseStep.waitUntilElement(Driver, loginPage.email, 20000);
                await loginPage.loginMerchant(Driver)
                await baseStep.wait(Driver, 1000);
                await baseStep.screenShot(Driver, savaPath + '/02_Menu.jpeg');
                await baseStep.wait(Driver, 1000);
                await baseStep.click(Driver, billableMetricPage.menu_billable_metric);
                await baseStep.wait(Driver, 1000);
                await baseStep.click(Driver, billableMetricPage.new_billable_metric);
                await baseStep.wait(Driver, 1000);
                await baseStep.input(Driver, billableMetricPage.metric_name, "name" + new Date().getTime());
                await baseStep.input(Driver, billableMetricPage.metric_code, "code" + new Date().getTime());
                await baseStep.input(Driver, billableMetricPage.metric_description, "description" + new Date().getTime());
                await billableMetricPage.selectAggregationType(Driver, "sum");
                await baseStep.input(Driver, billableMetricPage.aggregation_property, "100");

                await baseStep.screenShot(Driver, savaPath + '/10_info_sum.jpeg');
                await baseStep.click(Driver, billableMetricPage.save_btn);

                await baseStep.wait(Driver, 3000);
                await baseStep.screenShot(Driver, savaPath + '/11_list.jpeg');

                done();
            } catch (e) {
                done(e);
            } finally {
                await Driver.quit();
            }
        })();
    });

    it('Delay 5 seconds ', (done) => {
        setTimeout(() => {// TODO Need wait about syncTimeAPI second after last operation
            done();
        }, 5000);
    });

});

describe('case06: Add billable metric without param=> Success', function () {
    this.timeout(100000);

    beforeEach(function () {
        response = null;
        addContext(this, {
            title: 'StartTime',
            value: {
                StartTime: timeStamp = new Date()
            }
        });
    });
    afterEach(function () {
        if (response) {
            addContext(this, {
                title: 'Request',
                value: {
                    Request: request
                }
            });
            addContext(this, {
                title: 'Response',
                value: {
                    Response: response
                }
            });
        }
        addContext(this, {
            title: 'EndTime',
            value: {
                EndTime: timeStamp = new Date()
            }
        });

    });

    it('TC001 - add billable metric ,Aggregation Type = sum => Success  ', (done) => {
        (async () => {
            try {
                // login
                Driver = driver.getDriver(webdriver, 'chrome');
                // Check Url
                await loginPage.openMerchantUrl(Driver);
                const currentUrl = await Driver.getCurrentUrl();
                console.log('当前网址:', currentUrl);
                await baseStep.waitUntilElement(Driver, loginPage.email, 20000);
                await loginPage.loginMerchant(Driver)
                await baseStep.wait(Driver, 1000);
                await baseStep.click(Driver, billableMetricPage.menu_billable_metric);
                await baseStep.wait(Driver, 1000);
                await baseStep.click(Driver, billableMetricPage.new_billable_metric);
                await baseStep.wait(Driver, 1000);

                await baseStep.click(Driver, billableMetricPage.save_btn);
                await baseStep.screenShot(Driver, savaPath + '/11_error.jpeg');
                expect("Please select your aggregation type").to.equal(await baseStep.getText(Driver,billableMetricPage.aggregation_type_errpr));
                expect("Please input your property to aggregate !").to.equal(await baseStep.getText(Driver,billableMetricPage.aggregation_property_error));
                await baseStep.wait(Driver, 1000);
                done();
            } catch (e) {
                done(e);
            } finally {
                await Driver.quit();
            }
        })();
    });

    it('Delay 5 seconds ', (done) => {
        setTimeout(() => {// TODO Need wait about syncTimeAPI second after last operation
            done();
        }, 5000);
    });

});


describe('case07: Edit billable metric in Merchant Portal=> Success', function () {
    this.timeout(100000);

    beforeEach(function () {
        response = null;
        addContext(this, {
            title: 'StartTime',
            value: {
                StartTime: timeStamp = new Date()
            }
        });
    });
    afterEach(function () {
        if (response) {
            addContext(this, {
                title: 'Request',
                value: {
                    Request: request
                }
            });
            addContext(this, {
                title: 'Response',
                value: {
                    Response: response
                }
            });
        }
        addContext(this, {
            title: 'EndTime',
            value: {
                EndTime: timeStamp = new Date()
            }
        });

    });

    it('TC001 - Edit billable metric => Success  ', (done) => {
        (async () => {
            try {
                // login
                Driver = driver.getDriver(webdriver, 'chrome');
                // Check Url
                await loginPage.openMerchantUrl(Driver);
                const currentUrl = await Driver.getCurrentUrl();
                console.log('当前网址:', currentUrl);
                await baseStep.waitUntilElement(Driver, loginPage.email, 20000);
                await loginPage.loginMerchant(Driver)
                await baseStep.wait(Driver, 1000);
                await baseStep.wait(Driver, 1000);
                await baseStep.click(Driver, billableMetricPage.menu_billable_metric);
                await baseStep.wait(Driver, 1000);
                await billableMetricPage.editBillableMetric(Driver, "Editable metric");
                await baseStep.wait(Driver, 1000);
                await baseStep.inputWithClear(Driver, billableMetricPage.metric_description, "description" + new Date().getTime());
                await baseStep.screenShot(Driver, savaPath + '/12_edit.jpeg');
                await baseStep.click(Driver, billableMetricPage.save_btn);
                await baseStep.wait(Driver, 3000);

                done();
            } catch (e) {
                done(e);
            } finally {
                await Driver.quit();
            }
        })();
    });

    it('Delay 5 seconds ', (done) => {
        setTimeout(() => {// TODO Need wait about syncTimeAPI second after last operation
            done();
        }, 5000);
    });

});


