const baseStep = require("../../CommonStep/Web/Web_Common_Step");
const webdriver = require('selenium-webdriver');
const {expect} = require("chai");
const By = webdriver.By;

class UserMySubPage {
    menu_my_subscription=  '//*[@class="ant-menu-title-content" and text()="My Subscription"]'
    plan_name = '(//*[text()="Plan"]/following-sibling::div[1])'
    sub_status = '(//*[text()="Status"]/following-sibling::div[1]/span[1])'
    cancel_sub_button = '//span[text()="CANCEL"]'
    cancel_confirm_button = '//span[text()="Yes, Cancel it"]'
    go_to_choose_one = '//*[text()="Go to choose one"]'
    change_plan_btn = '//*[text()="Change Plan"]'
    resume_btn = '//*[text()="Un-cancel"]'
    End_Subscription_btn = '//*[text()= "End Subscription"]'
    OK_btn = '//*[text()="OK"]'

    selectProduct = async function (driver, name){
        console.log("select product: " + name);
        await baseStep.click(driver, "//*[text()='"+name+"']");
        await baseStep.wait(driver, 1000);
    }

    checkRecordHistoryList = async function(driver,  product="",  plan="", status= "" ,record = 1){
        await baseStep.waitUntilElement(driver, "//*[@class='ant-table-tbody']", 20000);
        await baseStep.wait(driver,5000);
        let table = await driver.findElement(By.xpath("//*[@class='ant-table-tbody']"));

        let rows = await table.findElements({ tagName: 'tr' })
        console.log("rows.length: ",rows.length)
        //*[@id="root"]/div/div/main/div/div/div[1]/div/div/div/div/div[2]/table/tbody/tr[2]/td[3]/div/span
        let cells =  await rows[record].findElements({ tagName: 'td' });
        if (product!== ""){
            let actual_product=  await  cells[0].getText()
            // let amount = await driver.findElement(By.xpath("//*[@id=\"root\"]/div/div/main/div/div/div[1]/div/div/div/div/div[2]/table/tbody/tr["+(record+1)+"]/td[3]/div/span"))
            expect(await actual_product).to.equal(product);
        }
        if (plan !== ""){
            let actual_plan =  await  cells[1].getText()
            // let actualStatus = await driver.findElement(By.xpath("//*[@id=\"root\"]/div/div/main/div/div/div[1]/div/div/div/div/div[2]/table/tbody/tr["+(record+1)+"]/td[4]/span"))
            expect(await actual_plan).to.equal(plan);
        }
        if (status !== ""){
            let actual_status=  await  cells[4].getText()
            expect(actual_status).to.equal(status);
        }

    }

    isProductSelected = async function(driver, productName){
        let element = await driver.findElement(By.xpath("//*[text()='"+productName+"']"));
        return await element.getAttribute('aria-selected');
    }
}


module.exports = new UserMySubPage();
