const baseStep = require("../../CommonStep/Web/Web_Common_Step");
const webdriver = require('selenium-webdriver');
const {expect} = require("chai");
const By = webdriver.By;

class UserMyAccountPage {
    menu_my_account=  '//*[@class="ant-menu-title-content" and text()="My Account"]'
    account_type_Individual = '//*[text()="Individual"]'
    account_type_Business = '//*[text()="Business"]'
    first_name = '//*[@id="firstName"]'
    last_name = '//*[@id="lastName"]'
    email = '//*[@id="email"]'
    country = '//*[@id="countryCode"]'
    city = '//*[@id="city"]'
    zipCode = '//*[@id="zipCode"]'
    billing_address = '//*[@id="address"]'
    company_name = '//*[@id="companyName"]'
    VATNumber = '//*[@id="vATNumber"]'
    account_country = '//*[@id="countryCode"]'
    phone_number = '//*[@id="phone"]'
    Save_btn = '//*[text()="Save"]'
    change_wire_error_message ='//*[contains(text(), "Can\'t change gateway to wire transfer, Please contact billing admin")]'
    change_password_btn = '//*[text()="Change Password"]'
    old_password = '//*[@id="oldPassword"]'
    new_password = '//*[@id="newPassword"]'
    new_password_confirm = '//*[@id="newPassword2"]'
    OK_btn = '//*[text()="OK"]'
    payment_stripe = '//*[@for="payment-stripe"]'
    payment_wire_transfer = '//*[@for="payment-wire_transfer"]'
    payment_crypto = '//*[@for="payment-changelly"]'

    auto_pay_radio_2 = '(//*[@name="payment-methods"])[2]'
    set_as_auto_payment = '//*[text()="Set as auto payment card"]'
    add_new_card = '//*[@aria-label="plus"]'
    auto_pay_delete_2 = '(//*[@aria-label="minus"])[2]'
    delete_yes_btn = '//*[text()="Yes"]'
    vat_error_message = '//*[contains(text(), "AT number validation failed. ")]'
    country_error_message = '//*[contains(text(), "Your country from vat number is")]'


    setCountry= async function (driver, countryName){
        console.log("set country: " , countryName);
        // await driver.executeScript(`document.getElementsByClassName("ant-select-selection-item").title = '${countryName}';`)
        // await driver.executeScript(`document.getElementsByClassName("ant-select-selection-item").textContent = '${countryName}';`)
        // let element = driver.findElement(By.className('ant-select-selection-item'));
        //
        // let js = `arguments[0].setAttribute("title", "${countryName}");`;
        // await driver.executeScript(js, element);
        // await driver.executeScript(`arguments[0].innerText = "${countryName}";`, element);
        let xpath = '//div[3]/div/div/div[2]/div/div/div/div/div';
        await baseStep.input(driver, this.account_country, countryName);
        await baseStep.input(driver, this.account_country,'\uE007');
        await baseStep.wait(driver, 1000);
    }

}

module.exports = new UserMyAccountPage();
