let loginPage = require("../../PageObject/LoginPage");
let userPlanPage = require("../../PageObject/UserPlanPage");
let userListPage = require("../../PageObject/MerchantUserListPage")
const urlencoded = require('urlencode');

const webdriver = require('selenium-webdriver');
const By = webdriver.By;
const driver = require('../../../CommonStep/Web/seleniumWebDriver');
const baseStep = require('../../../CommonStep/Web/Web_Common_Step');

const API_Object = require("../../../CommonStep/API/API_Object");
const API_Env = require("../../../CommonStep/API/API_Env");
const ApiReq = new API_Object("http://localhost:8088");

const addContext = require('mochawesome/addContext');
const {expect} = require("chai");
const {wait} = require("../../../CommonStep/Web/Web_Common_Step");
const merchantInvoicePage = require("../../PageObject/MerchantInvoicePage");
const discountCodePage = require("../../PageObject/MerchantDiscountCodePage");
let request;
let response;
let timeStamp = new Date();

let Driver;
let savaPath = __dirname + "/../../Report/Web/ScreenShot/09_user_list/" + baseStep.getDateFormat(new Date(),"YYYY-MM-DD_HH:mm:ss");
let testData = [];
let testUser = "joshua.yu@wowow.io";
describe('TS001: add user in user list=> Success', function() {
    this.timeout(9000000);

    beforeEach(function () {
        response = null;
        addContext(this, {
            title: 'StartTime',
            value: {
                StartTime: timeStamp = new Date()
            }
        });
    });
    afterEach(function () {
        if (response) {
            addContext(this, {
                title: 'Request',
                value: {
                    Request: request
                }
            });
            addContext(this, {
                title: 'Response',
                value: {
                    Response: response
                }
            });
            addContext(this, {
                title: 'EndTime',
                value: {
                    EndTime: timeStamp = new Date()
                }
            });
        }
    });



    it('case 01 - add a new user => Success  ', (done) => {
        (async () => {
            try {
                // login
                Driver = driver.getDriver(webdriver, 'chrome');
                // Check Url
                await loginPage.openMerchantUrl(Driver, "http://unibee:123456@localhost/plan/list/");
                const currentUrl = await Driver.getCurrentUrl();
                console.log('当前网址:', currentUrl);
                await baseStep.waitUntilElement(Driver, loginPage.email,20000);
                await loginPage.loginMerchant(Driver, "accounts.unibee@unibee.dev", "changeme")
                await baseStep.wait(Driver, 1000);
                await baseStep.waitUntilElement(Driver, userListPage.menu_user_list);
                await baseStep.click(Driver, userListPage.menu_user_list);
                await baseStep.wait(Driver,2000);
                await baseStep.click(Driver, userListPage.add_new_btn);
                await baseStep.wait(Driver,2000);
                let time = new Date().getTime();
                await baseStep.input(Driver, userListPage.new_email, "Auto"+ time + "@test.com");
                await baseStep.input(Driver, userListPage.new_ex_user_id, time);
                await baseStep.input(Driver, userListPage.new_first_name, "Testing");
                await baseStep.input(Driver, userListPage.new_last_name, "QA" + time);
                await baseStep.input(Driver, userListPage.new_phone, "15642543250");
                await baseStep.input(Driver, userListPage.new_address, "Test Address");
                await baseStep.screenShot(Driver, savaPath + "/01_add_user");
                await baseStep.click(Driver, userListPage.new_OK_btn);
                await baseStep.wait(Driver,1000);
                await baseStep.screenShot(Driver, savaPath + "/02_user_list");
                await userListPage.checkRecordUserList(Driver, "Testing QA"+time, "Auto"+ time + "@test.com","Active");
                await baseStep.scrollIntoView(Driver,userListPage.suspend_btn);
                await baseStep.click(Driver, userListPage.suspend_btn);
                await baseStep.screenShot(Driver, savaPath + "/03_suspend_user");
                await baseStep.click(Driver, userListPage.suspend_confirm_btn);
                await baseStep.click(Driver, userListPage.menu_user_list);
                await baseStep.wait(Driver,2000);
                await baseStep.screenShot(Driver, savaPath + "/04_suspend_result");
                await userListPage.checkRecordUserList(Driver, "Testing QA"+time, "Auto"+ time + "@test.com","Suspended");
                done();
            }
            catch (e) {
                done(e);
            }finally {
                await Driver.quit();
            }
        })();
    });

    it('Delay 5 seconds ', (done) => {
        setTimeout(() => {// TODO Need wait about syncTimeAPI second after last operation
            done();
        }, 5000);
    });

});

describe('TS002: Assign subscription in user list=> Success', function() {
    this.timeout(9000000);

    beforeEach(function () {
        response = null;
        addContext(this, {
            title: 'StartTime',
            value: {
                StartTime: timeStamp = new Date()
            }
        });
    });
    afterEach(function () {
        if (response) {
            addContext(this, {
                title: 'Request',
                value: {
                    Request: request
                }
            });
            addContext(this, {
                title: 'Response',
                value: {
                    Response: response
                }
            });
            addContext(this, {
                title: 'EndTime',
                value: {
                    EndTime: timeStamp = new Date()
                }
            });
        }
    });



    it('case 01 - Assign a sub => Success  ', (done) => {
        (async () => {
            try {
                // login
                Driver = driver.getDriver(webdriver, 'chrome');
                // Check Url
                await loginPage.openMerchantUrl(Driver, "http://unibee:123456@localhost/plan/list/");
                const currentUrl = await Driver.getCurrentUrl();
                console.log('当前网址:', currentUrl);
                await baseStep.waitUntilElement(Driver, loginPage.email,20000);
                await loginPage.loginMerchant(Driver, "accounts.unibee@unibee.dev", "changeme")
                await baseStep.wait(Driver, 1000);
                await baseStep.waitUntilElement(Driver, userListPage.menu_user_list);
                await baseStep.click(Driver, userListPage.menu_user_list);
                await baseStep.wait(Driver,2000);
                await baseStep.click(Driver, userListPage.add_new_btn);
                await baseStep.wait(Driver,2000);
                let time = new Date().getTime();
                await baseStep.input(Driver, userListPage.new_email, "Auto"+ time + "@test.com");
                await baseStep.input(Driver, userListPage.new_ex_user_id, time);
                await baseStep.input(Driver, userListPage.new_first_name, "Testing");
                await baseStep.input(Driver, userListPage.new_last_name, "QA" + time);
                await baseStep.input(Driver, userListPage.new_phone, "15642543250");
                await baseStep.input(Driver, userListPage.new_address, "Test Address");
                await baseStep.screenShot(Driver, savaPath + "/05_add_user");
                await baseStep.click(Driver, userListPage.new_OK_btn);
                await baseStep.wait(Driver,1000);
                await baseStep.screenShot(Driver, savaPath + "/06_user_list");
                await userListPage.checkRecordUserList(Driver, "Testing QA"+time, "Auto"+ time + "@test.com","Active");
                await baseStep.click(Driver, userListPage.subscription_tab);
                await baseStep.wait(Driver,1000);
                await baseStep.click(Driver, userListPage.assign_sub_btn);
                await baseStep.wait(Driver,1000);
                await userListPage.selectTargetPlan(Driver, "Month Plan");
                await baseStep.wait(Driver,1000);
                await baseStep.screenShot(Driver, savaPath + "/07_assign_sub");
                await baseStep.click(Driver, userListPage.assign_OK_btn);
                await baseStep.wait(Driver,3000);
                await baseStep.screenShot(Driver, savaPath + "/08_assign_result");
                await baseStep.compareText(Driver, userListPage.current_text, "Current Subscription");
                await baseStep.compareText(Driver, userListPage.current_plan, "Month Plan");
                await baseStep.compareText(Driver, userListPage.current_plan_des, "Month Plan");
                await baseStep.compareText(Driver, userListPage.current_status, "Incomplete");
                done();
            }
            catch (e) {
                done(e);
            }finally {
                await Driver.quit();
            }
        })();
    });

    it('Delay 5 seconds ', (done) => {
        setTimeout(() => {// TODO Need wait about syncTimeAPI second after last operation
            done();
        }, 5000);
    });

});











