const baseStep = require("../../CommonStep/Web/Web_Common_Step");
const webdriver = require('selenium-webdriver');
const {expect} = require("chai");
const By = webdriver.By;

class MerchantUserListPage {
    menu_user_list=  '//*[@class="ant-menu-title-content" and text()="User List"]'
    filter_first_name = '//*[@id="firstName"]'
    filter_last_name = '//*[@id="lastName"]'
    filter_email = '//*[@id="email"]'
    clear_btn = '//*[text()="Clear"]'
    search_btn = '//*[text()="Search"]'
    add_new_btn = '//*[@aria-label="user-add"]'
    sub_id_link = '//*[@id="root"]/div/div/main/div/div/div[3]/div/div/div/div/div/table/tbody/tr/td[4]/div'
    info_first_name = '//*[text()="First Name"]/../following-sibling::div[1]'
    info_last_name = '//*[text()="Last Name"]/../following-sibling::div[1]'
    info_email = '//*[text()="Email"]/../following-sibling::div[1]/a'
    info_phone = '//*[text()="Phone"]/../following-sibling::div[1]'
    info_country = '//*[text()="Country"]/../following-sibling::div[1]'
    info_billing_address= '//*[text()="Billing Address"]/../following-sibling::div[1]'
    info_payment_method = '//*[text()="Payment Method"]/../following-sibling::div[1]'
    info_vat_number = '//*[text()="VAT Number"]/../following-sibling::div[1]'
    account_tab = '//*[@data-node-key="AccountInfo"]'
    subscription_tab = '//*[@id="rc-tabs-0-tab-subscription"]'
    invoice_tab = '//*[@data-node-key="Invoice"]'
    transaction_tab = '//*[@data-node-key="Transaction"]'
    new_email = '(//*[@id="email"])[2]'
    new_ex_user_id = '//*[@id="externalUserId"]'
    new_first_name = '(//*[@id="firstName"])[2]'
    new_last_name = '(//*[@id="lastName"])[2]'
    new_phone = '//*[@id="phone"]'
    new_address = '//*[@id = "address"]'
    new_OK_btn = '//*[text()="OK"]'
    suspend_btn = '//*[text()="Suspend"]'
    suspend_confirm_btn = '(//*[text()=\'Suspend\'])[2]'
    assign_sub_btn = '//*[text()="Assign Subscription"]'
    plan_selector = '(//input[@type="search"]/../..)'
    assign_OK_btn = '//*[text()="OK"]'
    current_text = '(//*[@class="ant-divider-inner-text"])[6]'
    current_plan = "//*[text()='Plan']/following-sibling::div[1]"
    current_plan_des = "(//*[text()='Plan Description'])[1]/following-sibling::div[1]"
    current_status= "(//*[text()='Status'])[3]//following-sibling::div[1]/span"
    plan_name = '(//*[text()="Plan"]/following-sibling::div[1])'
    sub_status = '(//*[text()="Status"]/following-sibling::div[1]/span[1])'
    plan_search_list = '//*[text()="Assign subscription"]/../following-sibling::div//input[@type="search"]/..'
    account_billing_address = '//*[@id="address"]'
    account_payment_stripe = '//*[@for="payment-stripe"]'
    account_payment_changelly = '//*[@for="payment-changelly"]'
    account_payment_wire_transfer = '//*[@for="payment-wire_transfer"]'
    account_vat_number = '//*[@id="vATNumber"]'
    account_country = '//*[@id="countryCode"]'
    vat_error_message = '//*[contains(text(), "AT number validation failed. ")]'
    country_error_message = '//*[contains(text(), "Your country from vat number is")]'
    save_btn = '//*[text()="Save"]'





    checkRecordUserList = async function(driver, name = "", email="", status="",record = 1){
        await baseStep.waitUntilElement(driver, "//*[@class='ant-table-cell' and text()='Email']", 20000);
        await baseStep.wait(driver,5000);
        let table = await driver.findElement(By.xpath("//*[@class='ant-table-tbody']"));

        let rows = await table.findElements({ tagName: 'tr' })
        console.log("rows.length: ",rows.length)

        let cells =  await rows[record-1].findElements({ tagName: 'td' });
        if (name !== ""){
            expect(await cells[0].getText()).to.equal(name);
        }
        if (email !== ""){

            expect(await cells[1].getText()).to.equal(email);
        }
        if (status !== ""){

            expect(await cells[6].getText()).to.equal(status);
        }
        await baseStep.click(driver, '//*[@id="root"]/div/div/main/div/div/div[3]/div/div/div/div/div/table/tbody/tr[1]/td[1]');
        await baseStep.wait(driver,3000);

    }

    selectTargetPlan = async function  (driver, Plan){
        console.log("select Plan name: " , Plan);
        try{
            await baseStep.click(driver, this.plan_selector + "[2]");
        }
        catch (e){
            await baseStep.click(driver, this.plan_selector + "[3]");
        }
        await baseStep.click(driver, "//*[contains(text(),'"+Plan+"')]");
        await baseStep.wait(driver, 1000);
    }

    selectProduct = async function (driver, name){
        console.log("select product: " + name);
        await baseStep.click(driver, "//*[text()='"+name+"']");
        await baseStep.wait(driver, 1000);
    }

    checkRecordHistoryList = async function(driver,  product="",  plan="", status= "" ,record = 1){
        await baseStep.waitUntilElement(driver, "//*[@class='ant-table-tbody']", 20000);
        await baseStep.wait(driver,5000);
        let table = await driver.findElement(By.xpath("//*[@class='ant-table-tbody']"));

        let rows = await table.findElements({ tagName: 'tr' })
        console.log("rows.length: ",rows.length)
        let cells =  await rows[record].findElements({ tagName: 'td' });
        if (product!== ""){
            let actual_product=  await  cells[0].getText()
            expect(await actual_product).to.equal(product);
        }
        if (plan !== ""){
            let actual_plan =  await  cells[1].getText()
            expect(await actual_plan).to.equal(plan);
        }
        if (status !== ""){
            let actual_status=  await  cells[4].getText()
            expect(actual_status).to.equal(status);
        }

    }

    clickAssignBtn = async function(driver){
        let btns = await driver.findElements(By.xpath(this.assign_sub_btn));
        for(let btn of btns){
            console.log("-------", btn);
            if (await btn.isDisplayed()){
                await btn.click();
                break;

            }
        }
    }

    setCountry= async function (driver, countryName){
        console.log("set country: " , countryName);
        // await driver.executeScript(`document.getElementsByClassName("ant-select-selection-item").title = '${countryName}';`)
        // await driver.executeScript(`document.getElementsByClassName("ant-select-selection-item").textContent = '${countryName}';`)
        // let element = driver.findElement(By.className('ant-select-selection-item'));
        //
        // let js = `arguments[0].setAttribute("title", "${countryName}");`;
        // await driver.executeScript(js, element);
        // await driver.executeScript(`arguments[0].innerText = "${countryName}";`, element);
        let xpath = '//div[3]/div/div/div[2]/div/div/div/div/div';
        await baseStep.input(driver, this.account_country, countryName);
        await baseStep.input(driver, this.account_country,'\uE007');
        await baseStep.wait(driver, 1000);
    }

}

module.exports = new MerchantUserListPage();
